
/*
  CLASSiC DAC, Copyright 2013 SILICON CHIP Publications
  spi.c: SD/MMC card SPI communication functions
  Written by Mauro Grassi and updated by Nicholas Vinen, 2009-2013
  Modified 2018 Tim Blythman for SoundFXV2
*/
//          SPI1 for SD Card (CD on RB13, pin24)

//// change these to suit the application ////
/*
#define SDCARD_SPI        1
#define SDCARD_DMA		  1
#define SDCARD_WDMA		  2
#define SDCARD_DIN_RP     14
#define SDCARD_DIN_PORT   B
#define SDCARD_DIN_PIN    14
#define SDCARD_CLK_RP     8
#define SDCARD_CLK_PORT   B
#define SDCARD_CLK_PIN    8
#define SDCARD_DOUT_RP    9
#define SDCARD_DOUT_PORT  B
#define SDCARD_DOUT_PIN   9
*/
/////////////////////////////////////////////

#include "GenericTypeDefs.h"
#include "spi.h"
//#include "p33Fxxxx.h"
//#include <string.h>

/* 
	SPI Module Firmware
	by Mauro Grassi, 2009-2010.
*/
/*
#define _SPISTATname(spi) SPI##spi##STAT
#define SPISTATname(spi)  _SPISTATname(spi)
#define _SPISTATbits(spi) SPI##spi##STATbits
#define SPISTATbits(spi)  _SPISTATbits(spi)
#define _SPICON1name(spi) SPI##spi##CON1
#define SPICON1name(spi)  _SPICON1name(spi)
#define _SPICON1bits(spi) SPI##spi##CON1bits
#define SPICON1bits(spi)  _SPICON1bits(spi)
#define _SPICON2name(spi) SPI##spi##CON2
#define SPICON2name(spi)  _SPICON2name(spi)
#define _SPIBUFname(spi)  SPI##spi##BUF
#define SPIBUFname(spi)   _SPIBUFname(spi)
#define _SPIIEname(spi)   _SPI##spi##IE
#define SPIIEname(spi)    _SPIIEname(spi)
#define _SPIIFname(spi)   _SPI##spi##IF
#define SPIIFname(spi)    _SPIIFname(spi)
#define _RPORbits(a,b)    RPOR##a##bits.RP##b##R
#define RPORbits(a,b)     _RPORbits(a,b)
#define _TRISbits(a,b)    TRIS##a##bits.TRIS##a##b
#define TRISbits(a,b)     _TRISbits(a,b)
#define _LATbits(a,b)     LAT##a##bits.LAT##a##b
#define LATbits(a,b)      _LATbits(a,b)
#define _DMACONname(dma)  DMA##dma##CON
#define DMACONname(dma)   _DMACONname(dma)
#define _DMACONbits(dma)  DMA##dma##CONbits
#define DMACONbits(dma)   _DMACONbits(dma)
#define _DMASTAname(dma)  DMA##dma##STA
#define DMASTAname(dma)   _DMASTAname(dma)
#define _DMASTBname(dma)  DMA##dma##STB
#define DMASTBname(dma)   _DMASTBname(dma)
#define _DMAPADname(dma)  DMA##dma##PAD
#define DMAPADname(dma)   _DMAPADname(dma)
#define _DMACNTname(dma)  DMA##dma##CNT
#define DMACNTname(dma)   _DMACNTname(dma)
#define _DMAREQname(dma)  DMA##dma##REQ
#define DMAREQname(dma)   _DMAREQname(dma)

#define SLOW_SPI_DELAY 4096

#ifdef USE_DMA
unsigned char* SPIRxBuf;
volatile unsigned short SPIRxLeft;
#endif
*/
void DeinitSPI() {
    //CD setup
    CNPUBbits.CNPUB13=0;     //CD pullup off, should be pulled low by card detect pin

	SDCS_TRIS=1;
	SDCS=0;
    SPI1CON=0;                  //reset SPI, sets 8bit data, frame sync off, use PBCLK, SDI in use

    /*
	SPISTATname(SDCARD_SPI)=0;
	SPICON1name(SDCARD_SPI)=0;
	SPICON2name(SDCARD_SPI)=0;

 */
}

void InitSPI(int speed)
{
    //CD setup
    TRISBbits.TRISB13=1;     //CD input working
    CNPUBbits.CNPUB13=1;     //CD pullup    

    //CS1 manual control
	SDCS=1;
	SDCS_TRIS=0;
    
    //SD Card on SPI1
    SPI1CON=0;                  //reset SPI, sets 8bit data, frame sync off, use PBCLK, SDI in use
    SPI1BUF;                    //read rx buffer
    SPI1CONbits.MSTEN=1;        //Master
    SPI1CONbits.CKE=1;          //edge
    SPI1CONbits.CKP=0;          //polarity
    //SPI1CONbits.MSSEN=1;      //control SS on xmit
    SPI1CONbits.MSSEN=0;        //manually control SS    
    SPI1CON2=0;                 //clear CON2, disable audio, disable interrupt flags
    //SPI1BRG=speed;              //PBCLK/(2*(speed+1))=> 0=12MHz, 511=23.4kHz
    //SPI1BRG=50;                 //generic slow, but working
    SPI1BRG=0;                   //12MHz
    if(speed==1){
        SPI1BRG=39;              //300kHz
    }
    
    SPI1CONbits.ON=1;           //turn on SPI1
}

unsigned int WriteSPI(unsigned int x) {
	SDCS=0;
    while(!SPI1STATbits.SPITBE){}       //wait for buffer empty
    SPI1BUF=x;                          //write
    while(SPI1STATbits.SPIBUSY||(!SPI1STATbits.SPIRBF)){}       //wait to finish and data to be in buffer
    SDCS=1;
    x=SPI1BUF;
    return x;
    
    
    /*
	SDCS=0;
	if( (SPICON1name(SDCARD_SPI)&0x1F) == 0x01 ) {
		unsigned short i;
		for( i = 0; i < SLOW_SPI_DELAY; ++i )
			Nop();

		SPIBUFname(SDCARD_SPI)=x;
		while(SPISTATbits(SDCARD_SPI).SPIRBF==0 && SPISTATbits(SDCARD_SPI).SPIEN)
			;
		x=SPIBUFname(SDCARD_SPI);

		for( i = 0; i < SLOW_SPI_DELAY; ++i )
			Nop();
		SDCS=1;
		for( i = 0; i < SLOW_SPI_DELAY; ++i )
			Nop();
	} else {
		SPIBUFname(SDCARD_SPI)=x;
		while(SPISTATbits(SDCARD_SPI).SPIRBF==0&&SPISTATbits(SDCARD_SPI).SPIEN)
			;
		x=SPIBUFname(SDCARD_SPI);
		SDCS=1;
	}
	return x;
*/
}
/*
#ifdef USE_DMA
void __attribute__((__interrupt__,no_auto_psv)) _SPI1Interrupt(void) {
	register unsigned short temp;

	temp = SPIBUFname(SDCARD_SPI);
    if( --SPIRxLeft )
		SPIBUFname(SDCARD_SPI) = 0;
    ((unsigned short*)SPIRxBuf)[0] = (temp>>8)|(temp<<8);
    SPIRxBuf += 2;
	SPIIFname(SDCARD_SPI)=0;
}

void BulkReadSPI(BYTE* data) {
	SPISTATbits(SDCARD_SPI).SPIEN=0;
	SPICON1bits(SDCARD_SPI).DISSDO=1;
	SPICON1bits(SDCARD_SPI).MODE16=1;
	SPISTATbits(SDCARD_SPI).SPIEN=1;

	SDCS = 0;

	SPIRxBuf = data;
	SPIRxLeft = 256;
	SPIIFname(SDCARD_SPI)=0;
	SPIIEname(SDCARD_SPI)=1;
	SPIBUFname(SDCARD_SPI) = 0;
	while( SPIRxLeft && SPISTATbits(SDCARD_SPI).SPIEN )
		;

	SPISTATbits(SDCARD_SPI).SPIEN=0;
	SPICON1bits(SDCARD_SPI).DISSDO=0;
	SPICON1bits(SDCARD_SPI).MODE16=0;
	SPISTATbits(SDCARD_SPI).SPIEN=1;
	SPIIEname(SDCARD_SPI)=0;

	SDCS = 1;
}
#endif
*/

unsigned int WriteSPIWithoutSS(unsigned int x)
{
    while(!SPI1STATbits.SPITBE){}       //wait for buffer empty
    SPI1BUF=x;                          //write
    while(SPI1STATbits.SPIBUSY||(!SPI1STATbits.SPIRBF)){}       //wait to finish and data to be in buffer
    x=SPI1BUF;
    return x;

    /*
	if( (SPICON1name(SDCARD_SPI)&0x1F) == 0x00 ) {
		unsigned short i;
		for( i = 0; i < SLOW_SPI_DELAY; ++i )
			Nop();
	}
	SPIBUFname(SDCARD_SPI)=x;
	while(SPISTATbits(SDCARD_SPI).SPIRBF==0)
		;
	x=SPIBUFname(SDCARD_SPI);
	if( (SPICON1name(SDCARD_SPI)&0x1F) == 0x00 ) {
		unsigned short i;
		for( i = 0; i < SLOW_SPI_DELAY; ++i )
			Nop();
	}
	return x;
*/
}
